package com.foobar;

import org.apache.log4j.Logger;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.request.Request;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;


/**
 * Authenticated session subclass. Note that it is derived from AuthenticatedWebSession which is
 * defined in the auth-role module.
 * 
 * @author Jonathan Locke
 */
public class MyAuthenticatedWebSession extends AuthenticatedWebSession
{

	private static final long serialVersionUID = 1L;
	
	private static final Logger logger = Logger.getLogger(MyAuthenticatedWebSession.class);
	
	@SpringBean(name="authenticationManager")
	private AuthenticationManager authenticationManager;
	
//	final String WICKET = "wicket";
//	final String DUDE = "dude";
//	Roles roles = new Roles();
//	String name = new String();
	
	
	
	/**
	 * Construct.
	 * 
	 * @param request
	 *            The current request object
	 */
	public MyAuthenticatedWebSession(Request request)
	{
		super(request);
		injectDependencies();
		ensureDependenciesNotNull();
	}
	
    private void ensureDependenciesNotNull() {
        if (authenticationManager == null) {
            throw new IllegalStateException("AdminSession requires an authenticationManager.");
        }
    }
	
	   private void injectDependencies() {
	        Injector.get().inject(this);
	    }


	/**
	 * @see org.apache.wicket.authentication.AuthenticatedWebSession#authenticate(java.lang.String,
	 *      java.lang.String)
	 */
	   
	    @Override
	    public boolean authenticate(String username, String password) {
	        boolean authenticated = false;
	        try {
	            Authentication authentication = authenticationManager.authenticate(new UsernamePasswordAuthenticationToken(username, password));
	            SecurityContextHolder.getContext().setAuthentication(authentication);
	            authenticated = authentication.isAuthenticated();
	        } catch (AuthenticationException e) {
	            logger.warn(String.format("User '%s' failed to login. Reason: %s", username, e.getMessage()));
	            authenticated = false;
	        }
	        return authenticated;
	    }	   
//	@Override
//	public boolean authenticate(final String username, final String password)
//	{
//		// Check username and password
//		if ( WICKET.equals(username) && WICKET.equals(password) )
//		{
//			roles.add(Roles.ADMIN) ;
//			name = WICKET;
//			return true;
//		}
//		else if ( DUDE.equals(username) && DUDE.equals(password) )
//		{
//			roles.add(Roles.USER);
//			name = DUDE;
//			return true;
//		}
//		else
//			return false;
//	}

	/**
	 * @see org.apache.wicket.authentication.AuthenticatedWebSession#getRoles()
	 */
	@Override
	public Roles getRoles()
	{
        Roles roles = new Roles();
        getRolesIfSignedIn(roles);
        return roles;
	}
	
    private void getRolesIfSignedIn(Roles roles) {
        if (isSignedIn()) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            addRolesFromAuthentication(roles, authentication);
        }
    }
    
    private void addRolesFromAuthentication(Roles roles, Authentication authentication) {
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            roles.add(authority.getAuthority());
        }
    }
}
