package com.foobar;

import org.apache.wicket.Page;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.authroles.authentication.AuthenticatedWebApplication;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * Application object for your web application. If you want to run this application without deploying, run the Start class.
 * 
 * @see com.foobar.Start#main(String[])
 */
public class WicketApplication extends AuthenticatedWebApplication
{    	
	
	boolean isInitialized = false;
	/**
	 * @see org.apache.wicket.Application#getHomePage()
	 */
	@Override
	public Class<? extends 	Page> getHomePage()
	{
		return HomePage.class;
	}

	/**
	 * @see org.apache.wicket.Application#init()
	 */
	@Override
	public void init()
	{
        if (!isInitialized) {
            super.init();
            setListeners();
            isInitialized = true;
        }
	}
	
    private void setListeners() {
    	getComponentInstantiationListeners().add(new SpringComponentInjector(this));
      
    }
	
	/**
	 * @see org.apache.wicket.authentication.AuthenticatedWebApplication#getWebSessionClass()
	 */
	@Override
	protected Class<? extends AbstractAuthenticatedWebSession> getWebSessionClass()
	{
		return MyAuthenticatedWebSession.class;
	}

	/**
	 * @see org.apache.wicket.authentication.AuthenticatedWebApplication#getSignInPageClass()
	 */
	@Override
	protected Class<? extends WebPage> getSignInPageClass()
	{
		return MySignInPage.class;
	}


	
	
	
}
