package com.foobar;



import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.request.Request;


/**
 * Authenticated session subclass. Note that it is derived from AuthenticatedWebSession which is
 * defined in the auth-role module.
 * 
 * @author Jonathan Locke
 */
public class MyAuthenticatedWebSession extends AuthenticatedWebSession
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	final String WICKET = "wicket";
	final String DUDE = "dude";
	Roles roles = new Roles();
	String name = new String();
	
	/**
	 * Construct.
	 * 
	 * @param request
	 *            The current request object
	 */
	public MyAuthenticatedWebSession(Request request)
	{
		super(request);
	}


	/**
	 * @see org.apache.wicket.authentication.AuthenticatedWebSession#authenticate(java.lang.String,
	 *      java.lang.String)
	 */
	@Override
	public boolean authenticate(final String username, final String password)
	{
		// Check username and password
		if ( WICKET.equals(username) && WICKET.equals(password) )
		{
			roles.add(Roles.ADMIN) ;
			name = WICKET;
			return true;
		}
		else if ( DUDE.equals(username) && DUDE.equals(password) )
		{
			roles.add(Roles.USER);
			name = DUDE;
			return true;
		}
		else
			return false;
	}

	/**
	 * @see org.apache.wicket.authentication.AuthenticatedWebSession#getRoles()
	 */
	@Override
	public Roles getRoles()
	{
		if (isSignedIn())
		{
			// If the user is signed in, they have these roles
			return roles;
		}
		return null;
	}
}
