package com.brie.dtoo.forms;


import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;


import com.brie.dtoo.Customer;



public class Form1 extends Form<Customer> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
    private TextField<String> nameField;
    private TextField streetField;
    private PropertyModel namePropModel;
    private PropertyModel streetPropModel;
    private Model<Customer> myModel;
	
    public Form1(String id) {
        super(id);
        
        Customer customer = new Customer();
        myModel = new Model<Customer>(customer);
        setModel(myModel);
        
        namePropModel = new PropertyModel<Customer>(customer, "firstName");
        nameField = new TextField<String>("name",namePropModel);
        add(nameField);
        
        streetPropModel = new PropertyModel<Customer>(customer, "address.street");
        streetField = new TextField<String>("street", streetPropModel);
        add(streetField);

      }
    
    protected void onSubmit() {
    	Customer customer =  getModelObject();
        String street = customer.getAddress().getStreet();
        // do something with/to the customer
      }

}
