package com.brie.dtoo.forms;


import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;

import com.brie.dtoo.Customer;

public class Form1 extends Form<Customer> {

	private static final long serialVersionUID = 1L;
    private TextField<String> fnameField;
    private TextField<String> lnameField;
    private TextField<String> streetField;
	
    public Form1(String id, CompoundPropertyModel<Customer> myModel) {
    //public Form1(String id) {
        super(id);
                
        setModel(myModel);
        
        fnameField = new TextField<String>("firstName");
        add(fnameField);
        
        lnameField = new TextField<String>("lastName");
        add(lnameField);
        
        streetField = new TextField<String>("address.street");
        add(streetField);

      }
    
    protected void onSubmit() {
    	Customer customer =  getModelObject();
        String street = customer.getAddress().getStreet();
        // Probably should use logging here!
        System.out.println("Customer street is " + street);
        // do something with/to the customer
      }

}
