package com.brie.dtoo;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.PropertyModel;

import com.brie.dtoo.callbacks.CheeseDetach;
import com.brie.dtoo.callbacks.CheeseList;

public class Index extends CheesrPage {
  public Index() {
	  
	  // LoadableDetachableModel<List<Cheese>> 
	  CheeseDetach myDetach = new CheeseDetach(getDAO());
	  // ListView<Cheese> bound to "cheese" on html
	  CheeseList myCheeseList = new CheeseList("cheeses", myDetach, getCart());
	  // Add it to the page
	  add(myCheeseList);
	  
	  
	  add(new ListView("cart", new PropertyModel
				(this, "cart.cheeses")) {

				@Override
				protected void populateItem(ListItem item) {
					Cheese cheese = (Cheese) item.getModelObject();

					item.add(new Label("name", cheese.getName()));
					item.add(new Label("price", "$" + cheese.getPrice()));

					item.add(new Link("remove", item.getModel()) {
						@Override
						public void onClick() {
							Cheese selected = (Cheese) getModelObject();
							getCart().getCheeses().remove(selected);
						}
					});
				}

			});
			add(new Label("total", "$" + getCart().getTotal()));
  }
  
  
}
