package com.brie.dtoo.callbacks;

import java.util.List;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
//import org.apache.wicket.model.IModel;

import com.brie.dtoo.Cart;
import com.brie.dtoo.Cheese;

public class CheeseList extends ListView<Cheese> {

	private static final long serialVersionUID = 1L;
	private Cart myCart;
	public CheeseList(String id, IModel<? extends List<? extends Cheese>> model, Cart cart) {
		super(id, model);
		myCart = cart;
	}

	@Override
	protected void populateItem(ListItem<Cheese> item) {
		Cheese cheese = item.getModelObject();
		item.add(new Label("name", cheese.getName()));
		item.add(new Label("description",
				cheese.getDescription()));
		item.add(new Label("price", "$" + cheese.getPrice()));
		item.add(new Link<Cheese>("add", item.getModel()) {
			private static final long serialVersionUID = 1L;

			@Override
			public void onClick() {
				Cheese selected =  getModelObject();
				myCart.getCheeses().add(selected);
			}
		}
		
		);
		
	}

}
