package com.brie.dtoo;

import java.io.Serializable;
import java.text.NumberFormat;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.list.PageableListView;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigator;
import org.apache.wicket.model.*;
import com.brie.dtoo.callbacks.*;	



public class Index extends CheesrPage {
  @SuppressWarnings({ "unchecked", "rawtypes", "serial" })
  
  public Index() {
	  
	  PageableListView cheeses 
	  	= new PageableListView("cheeses", getCheeses(), 4) {
		  
		  @Override
		  protected void populateItem(ListItem item) {
			  Cheese cheese = (Cheese) item.getModelObject();
			  item.add(new Label("name", cheese.getName()));
			  item.add(new Label("description", cheese.getDescription()));
			  item.add(new Label("price", "$" + cheese.getPrice()));
			  
			  Cart myCart = getCart();
			  
			  // Create a real callback rather than an anonymous inner class!
			  AddCheeseCB myAddCheese = new AddCheeseCB("add", item.getModel(), myCart);
			  item.add(myAddCheese);			  
		  }
	  };
	  
	  add(cheeses);
	  
	  add(new PagingNavigator("navigator", cheeses));
	   
	  add(new ShoppingCartPanel("shoppingcart", getCart()));
	  		
	  		
	  		add(new Link("checkout") {
	  			@Override
	  			public void onClick() {
	  				setResponsePage(new CheckOut());
	  			}
	  			
	  			@Override
	  			public boolean isVisible() {
	  				return !getCart().getCheeses().isEmpty();
	  			}
	  		});
	  		
  }
  
  
}
