package com.brie.dtoo;

import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.validator.StringValidator;

public class CheckOut extends CheesrPage {
	public CheckOut() {
		add(new FeedbackPanel("feedback"));
		Form form = new Form("form");
		add(form);
		Address address = getCart().getBillingAddress();
		
		TextField fieldName = new TextField("name", new PropertyModel(address, "name"));
		fieldName.setRequired(true);
		fieldName.add(StringValidator.lengthBetween(5, 32));
		form.add(fieldName);
		
		form.add(new TextField("street", new PropertyModel(address, "street")).setRequired(true) );
		form.add(new TextField("zipcode", new PropertyModel(address, "zipcode")).setRequired(true));
		form.add(new TextField("city", new PropertyModel(address, "city")).setRequired(true));
		
		form.add(new Link("cancel") {
			/**
			 * 
			 */
			private static final long serialVersionUID = 1L;

			@Override
			public void onClick() {
				setResponsePage(Index.class);
			}
		});
		
		form.add(new Button("order") {
			/**
			 * 
			 */
			private static final long serialVersionUID = 1L;

			@Override
			public void onSubmit() {
				Cart cart = getCart();
				// charge customer's credit card
				// ship cheeses to our customer
				// clean out shopping cart
				cart.getCheeses().clear();
				
				// return to front page
				setResponsePage(Index.class);
			}
		
		
		});
		add(new ShoppingCartPanel("shoppingcart", getCart()));

	}
}
