package com.brie.dtoo.callbacks;

import java.util.List;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.PageableListView;
import org.apache.wicket.model.IModel;

import com.brie.dtoo.Cart;
import com.brie.dtoo.Cheese;
import com.brie.dtoo.Index;

public class CheesePageList extends PageableListView<Cheese> {

	private Cart myCart;
	private Index myIndex;

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public CheesePageList(String id,
			IModel<? extends List<? extends Cheese>> model, int rowsPerPage) {
		super(id, model, rowsPerPage);
		
	}
	
	public CheesePageList(String id,
			List<Cheese> list, int rowsPerPage,
					Index index, Cart cart) {
		super(id, list, rowsPerPage);
		myIndex = index;
		myCart = cart;
	}

	@Override
	protected void populateItem(ListItem<Cheese> item) {
		  Cheese cheese =  item.getModelObject();
		  item.add(new Label("name", cheese.getName()));
		  item.add(new Label("description", cheese.getDescription()));
		  item.add(new Label("price", "$" + cheese.getPrice()));
		  
		  Cart myCart = myIndex.getCart();
		  
		  // Create a real callback rather than an anonymous inner class!
		  AddCheeseCB myAddCheese = new AddCheeseCB("add", item.getModel(), myCart);
		  item.add(myAddCheese);
		
	}

}
