/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <glib.h>
#include <glib/gprintf.h>
#include <stdlib.h>

#include "types.h"
#include "print.h"
#include "service_attacks.h"

#ifndef SWAP_4
#define SWAP_4(x) ( ((x) << 24) | \
         (((x) << 8) & 0x00ff0000) | \
         (((x) >> 8) & 0x0000ff00) | \
         ((x) >> 24) )
#endif

void display_list(GSList *list)
{
    GSList *iterator = NULL;
    individual *myInd;


    // g_printf("print the data:\n");
    //print the list data
    for (iterator = list; iterator; iterator = iterator->next) {
        myInd = (individual*)iterator->data;
	g_printf("%s\n",myInd->desc);

	print_individual(myInd);
	g_printf("\n");
    }

}

void display_array(GPtrArray *myArray)
{
  guint i;
  individual *trainer;
  gdouble myFit;

  for (i=0; i < (myArray->len) ;  i++ ) { 
       trainer = g_ptr_array_index(myArray, i);
       print_individual(trainer);       
       myFit = trainer->fitness;
       g_print("fitness is %.04f\n",myFit);
  }
}

void print_individual( individual *myInd ) {
  set_string_individual(myInd);
  g_printf("%s\n",myInd->desc);
}

void set_string_individual( individual *myInd ) {
  int i,j,k;
  guchar uv;
  char tmp[DESC_SZ];
  time_stamp tmpS;

  // Set description to empty string
  *(myInd->desc) = '\0';

  for (i=0; i<7; i++)  {
    switch (i) {
      
    case 0: // Duration
      //tmp = SWAP_4(myInd->chrome[i]);
      //g_printf("%08x ", tmp);
      tmpS.tot = myInd->chrome[i];
      for (j=1; j< 4; j++) {
	uv = (guchar)tmpS.byte[j];
	if ( uv < 255 ) // Check if it is neg1
	  k = uv;
	else
	  k = -1;
	g_snprintf(tmp,DESC_SZ, "%02d",k);
	g_strlcat(myInd->desc,tmp,DESC_SZ);
	if (j<3)
	  g_snprintf(tmp,DESC_SZ, ",");
	else
	  g_snprintf(tmp,DESC_SZ, " ");
	g_strlcat(myInd->desc,tmp,DESC_SZ);

      }
      break;
    case 4: // source IP
    case 5: // destination IP
      tmpS.tot = myInd->chrome[i];
      for (j=0; j< 4; j++) {
	uv = (guchar)tmpS.byte[j];
	if ( uv < 255 ) // Check if it is neg1
	  k = uv;
	else
	  k = -1;
	//g_printf("%03d", k);
	g_snprintf(tmp,DESC_SZ, "%03d",k);
	g_strlcat(myInd->desc,tmp,DESC_SZ);
	if (j<3)
	  //g_print(".");
	  g_snprintf(tmp,DESC_SZ, ".");
	else
	  g_snprintf(tmp,DESC_SZ, " ");
	g_strlcat(myInd->desc,tmp,DESC_SZ);
      }

      break;
    case 1: // protocol
      switch (myInd->chrome[i]) {
      case EXEC:
	g_snprintf(tmp,DESC_SZ, "  exec");
	break;
      case FINGER:
	g_snprintf(tmp,DESC_SZ, "finger");
	break;
      case FTP:
	g_snprintf(tmp,DESC_SZ,"   ftp" );
	break;
      case RLOGIN:
	g_snprintf(tmp,DESC_SZ, "rlogin" );
	break;
      case RSH:
	g_snprintf(tmp,DESC_SZ, "   rsh" );
	break;
      case SMTP:
	g_snprintf(tmp,DESC_SZ, "  smtp" );
	break;
      case TELNET:
	g_snprintf(tmp,DESC_SZ,"telnet" );
	break;
      default:
	g_snprintf(tmp,DESC_SZ, " %05d", myInd->chrome[i]);
	
      }
      g_strlcat(myInd->desc,tmp,DESC_SZ);
      g_strlcat(myInd->desc," ",DESC_SZ);
      break;

    case 6: // attack
      switch (myInd->chrome[i]) {
      case NONE: 
	g_snprintf(tmp,DESC_SZ, "none");
	break;
      case GUESS_A: 
	g_snprintf(tmp,DESC_SZ, "guess");
	break;
      case PORT_SCAN_A: 
	g_snprintf(tmp,DESC_SZ, "port-scan");
	break;
      case RCP_A: 
	g_snprintf(tmp,DESC_SZ, "rcp");
	break;
      case RLOGIN_A: 
	g_snprintf(tmp,DESC_SZ, "rlogin");
	break;
      case RSH_A: 
	g_snprintf(tmp,DESC_SZ, "rsh");
	break;
      case FORMAT_CLEAR_A: 
	g_snprintf(tmp,DESC_SZ, "format_clear");
	break;
      case FFB_CLEAR_A: 
	g_snprintf(tmp,DESC_SZ, "ffb_clear");
	break;
      default:
	g_snprintf(tmp,DESC_SZ, "Unknown");
	//exit(1);
      }
      g_strlcat(myInd->desc,tmp,DESC_SZ);
      break;
    case 2:
    case 3:
      g_snprintf(tmp,DESC_SZ, "%08d ", myInd->chrome[i] );
      g_strlcat(myInd->desc,tmp,DESC_SZ);
      break;
    default: 
      g_snprintf(tmp,DESC_SZ, "%08x ", myInd->chrome[i] );
      g_strlcat(myInd->desc,tmp,DESC_SZ);
    }
  }

}
