/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <glib.h>
#include "types.h"
#include "rand.h"
#include "print.h"

void mydestroy(gpointer myInd) {
  individual *pInd;
  gdouble fitnessInd;
  pInd = (individual *)myInd;
  g_slice_free(individual, pInd);
}

int main() {
  GPtrArray *myAry;
  GRand *myRand;
  individual *theInd;
  guint i,j;

  g_mem_set_vtable(glib_mem_profiler_table);
  g_atexit(g_mem_profile);

  // Initialize the random number generator
  myRand = g_rand_new();

  for (j=0; j < 30000; j++) {
    myAry = g_ptr_array_new_with_free_func(mydestroy);
    
    // Add some individuals to the array.
    for (i=0; i<2500;i++) {
      makeRandIndV1(myRand, &theInd);
      g_ptr_array_add(myAry, theInd); 
    }

    // print them out
/*     for (i=0; i<2500;i++) { */
/*       theInd = g_ptr_array_index(myAry, i); */
/*       print_individual(theInd ); */
/*     } */

    // free the array.
    //  g_ptr_array_unref(myAry);
    g_ptr_array_free(myAry, TRUE);
  }


  return 0;
}
