/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <glib.h>
#include <glib/gprintf.h>
#include "types.h"
#include "compare.h"
#include "print.h"
#include "service_attacks.h"

#ifndef SWAP_4
#define SWAP_4(x) ( ((x) << 24) | \
         (((x) << 8) & 0x00ff0000) | \
         (((x) >> 8) & 0x0000ff00) | \
         ((x) >> 24) )
#endif 


int main() {

  individual *trainer,*audit;
  time_stamp c,d;

  trainer = (individual *)g_slice_alloc0(sizeof(individual));
  audit = (individual *)g_slice_alloc0(sizeof(individual));

  c.tot = 0x00000000; // zero the IP address before loading values
  d.tot = 0x00000000;

  // Duration
  // Hours
  c.byte[1] = 0xcd; // -1 is the wildcard
  d.byte[1] = 0xcd;

  // Minutes
  c.byte[2] = 0xff; // -1 is the wildcard
  d.byte[2] = 0x02;

  // Seconds
  c.byte[3] = 0x28; // -1 is the wildcard
  d.byte[3] = 0x28;

  g_printf("c is %08x\n",SWAP_4(c.tot)); // only need swap on little endian
  g_printf("d is %08x\n",SWAP_4(d.tot));
	   
  // Assign the Duration
  trainer->chrome[G_DURATION] = c.tot;
  audit->chrome[G_DURATION] = d.tot;

  // Assign the Protocol
  trainer->chrome[G_SERVICE] = FTP;
  audit->chrome[G_SERVICE] = FTP;

  // Assign the Source Port
  trainer->chrome[G_SOURCE_PORT] = -1;  // Wildcard is 0xFFFFFFFF or -1
  audit->chrome[G_SOURCE_PORT] = 65535; // Max port is 0x0000FFFF or 65,535   

  // Assign the Destination Port
  trainer->chrome[G_DEST_PORT] = 21  ;
  audit->chrome[G_DEST_PORT]   = 21;

  // Source IP Address
  c.tot = 0x00000000; // zero the IP address before loading values
  d.tot = 0x00000000;

  // 1st Octet
  c.byte[0] = 0x09; // -1 is the wildcard
  d.byte[0] = 0x09;

  // 2nd Octet
  c.byte[1] = 0x09; // -1 is the wildcard
  d.byte[1] = 0x09;

  // 3rd Octet
  c.byte[2] = 0x09; // -1 is the wildcard
  d.byte[2] = 0x09;

  // 4th Octet
  c.byte[3] = 0xFF; // -1 is the wildcard
  d.byte[3] = 0x09;

  g_printf("c is %08x\n",SWAP_4(c.tot)); // only need swap on little endian
  g_printf("d is %08x\n",SWAP_4(d.tot));


  // Assign the Source IP
  trainer->chrome[G_SRC_IP] = c.tot;
  audit->chrome[G_SRC_IP] = d.tot;

  // Destination IP Address
  c.tot = 0x00000000; // zero the temp variable
  d.tot = 0x00000000; // zero the temp variable

  // 1st Octet
  c.byte[0] = 0xc0; // 192
  d.byte[0] = 0xc0;

  // 2nd Octet
  c.byte[1] = 0xA8; // 168
  d.byte[1] = 0xA8;

  // 3rd Octet
  c.byte[2] = 0x01; // 1 
  d.byte[2] = 0x01; // -1 is the wildcard

  // 4th Octet
  c.byte[3] = 0x0D; // 12
  d.byte[3] = 0x0D; // -1

  g_printf("c is %08x\n",SWAP_4(c.tot));
  g_printf("d is %08x\n",SWAP_4(d.tot));


  // Assign the Destination IP
  trainer->chrome[G_DEST_IP] = c.tot;
  audit->chrome[G_DEST_IP] = d.tot;

  trainer->chrome[G_ATTACK] = PORT_SCAN_A;
  audit->chrome[G_ATTACK] = NONE;

  g_printf("Trainer\n");
  print_individual(trainer);
  g_printf("Audit\n");
  print_individual(audit);

  if ( compare_a(trainer,audit) == 1 )
    g_printf("Part A They match!\n");
  else
    g_printf("--No match Part A--\n");

  if ( compare_b(trainer,audit) == 1 )
    g_printf("Part B They match!\n");
  else
    g_printf("--No match Part B--\n");

  return 0;
}
