/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <string.h>
#include <glib.h>
#include <glib/gprintf.h>
#include "types.h"
#include "print.h"
#include "compare.h"
#include "service_attacks.h"

#ifndef SWAP_4
#define SWAP_4(x) ( ((x) << 24) | \
         (((x) << 8) & 0x00ff0000) | \
         (((x) >> 8) & 0x0000ff00) | \
         ((x) >> 24) )
#endif 

void mydestroy(gpointer myInd) {
  g_slice_free1(sizeof(individual), myInd);
  //g_free(myInd);
}

int main() {

  individual *parent1,*parent2;
  individual *child1, *child2, *child3, *child4;
  time_stamp c,d;
  gint randInt, whichbyte;
  guint base;
  gint offset = -1;
  gint idx = -1;
  GRand *rnd;

  rnd = g_rand_new();

  parent1 = g_slice_new0(individual);
  parent2 = g_slice_new0(individual);
  child1 = g_slice_new0(individual);
  child2 = g_slice_new0(individual);
  child3 = g_slice_new0(individual);
  child4 = g_slice_new0(individual);

  c.tot = 0x00000000; // zero the IP address before loading values
  d.tot = 0x00000000;

  // Duration
  // first byte -1. Not used
  c.byte[0] = 0xff; // -1 is the wildcard
  d.byte[0] = 0xff;

  // Duration
  // Hours
  c.byte[1] = 1; // -1 is the wildcard
  d.byte[1] = 0x00;

  // Minutes
  c.byte[2] = 0xff; // -1 is the wildcard
  d.byte[2] = 0x02;

  // Seconds
  c.byte[3] = 0x28; // -1 is the wildcard
  d.byte[3] = 0x24;

	   
  // Assign the Duration
  parent1->chrome[G_DURATION] = c.tot;
  parent2->chrome[G_DURATION] = d.tot;

  // Assign the Protocol
  parent1->chrome[G_SERVICE] = FTP;
  parent2->chrome[G_SERVICE] = RLOGIN;

  // Assign the Source Port
  parent1->chrome[G_SOURCE_PORT] = -1;  // Wildcard is 0xFFFFFFFF or -1
  parent2->chrome[G_SOURCE_PORT] = 44444; // Max port is 0x0000FFFF or 65,535   

  // Assign the Destination Port
  parent1->chrome[G_DEST_PORT] = 21  ;
  parent2->chrome[G_DEST_PORT]   = 25;

  // Source IP Address
  c.tot = 0x00000000; // zero the IP address before loading values
  d.tot = 0x00000000;

  // 1st Octet
  c.byte[0] = 0x09; // -1 is the wildcard
  d.byte[0] = 0x9E;

  // 2nd Octet
  c.byte[1] = 0x09; // -1 is the wildcard
  d.byte[1] = 0x22;

  // 3rd Octet
  c.byte[2] = 0x09; // -1 is the wildcard
  d.byte[2] = 0x02;

  // 4th Octet
  c.byte[3] = 0xFF; // -1 is the wildcard
  d.byte[3] = 0x14;



  // Assign the Source IP
  parent1->chrome[G_SRC_IP] = c.tot;
  parent2->chrome[G_SRC_IP] = d.tot;

  // Destination IP Address
  c.tot = 0x00000000; // zero the temp variable
  d.tot = 0x00000000; // zero the temp variable

  // 1st Octet
  c.byte[0] = 0xc0; // 192
  d.byte[0] = 0x87;

  // 2nd Octet
  c.byte[1] = 0xA8; // 168
  d.byte[1] = 0x23;

  // 3rd Octet
  c.byte[2] = 0x01; // 1 
  d.byte[2] = 0x22; // -1 is the wildcard

  // 4th Octet
  c.byte[3] = 0x0D; // 12
  d.byte[3] = 0xee; // -1



  // Assign the Destination IP
  parent1->chrome[G_DEST_IP] = c.tot;
  parent2->chrome[G_DEST_IP] = d.tot;

  parent1->chrome[G_ATTACK] = PORT_SCAN_A;
  parent2->chrome[G_ATTACK] = RCP_A;

  g_printf("Parent1\n");
  print_individual(parent1);
  g_printf("Parent2\n");
  print_individual(parent2);


  breed_midpoint(rnd, parent1, parent2, child1, child2);

  breed_midpoint(rnd, parent1, parent2, child3, child4);

  mydestroy(parent1);
  mydestroy(parent2);
  
  g_print("breed_midpoint\n");

  g_print("Child 1\n");
  set_string_individual(child1);
  g_print("%s\n", child1->desc);

  g_print("Child 2\n");
  set_string_individual(child2);
  g_print("%s\n", child2->desc);

  g_print("breed_midpoint\n");
  g_print("Child 3\n");
  g_strlcpy(child1->desc,"Test Individual", DESC_SZ);
  print_individual(child3);

  g_print("Child 4\n");
  g_strlcpy(child2->desc,"Test Individual", DESC_SZ);
  print_individual(child4);


  return 0;
}
