/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <string.h>
#include <glib.h>
#include <glib/gprintf.h>
#include "types.h"
#include "print.h"
#include "read_bsm.h"
#include "service_attacks.h"
#include "randslot.h"
#include "rand.h"
#include "compare.h"

#define WCARD_PROB 0.10

#ifndef SWAP_4
#define SWAP_4(x) ( ((x) << 24) | \
         (((x) << 8) & 0x00ff0000) | \
         (((x) >> 8) & 0x0000ff00) | \
         ((x) >> 24) )
#endif


int main() {
  GSList *auditList = NULL;
  gboolean matcha, matchb;
  guint counta, countb, countboth, length;

  GArray *myArrayL[NUM_HTABLES];
  GArray *myArrayC[NUM_HTABLES][SUBH];

  GSList *iterator = NULL;
  individual *myInd;
  individual *a; // Random Individual
  
  gint nRecords = 0;
  //  gint i; // loop counter


  char *myfile = "./bsm.list";
  //char *myfile2 = "./bsm2.list";

  nRecords = build_audit_array(&auditList, myArrayL, myArrayC, myfile);

  countboth = 0;
  countb = 0;

  while (countboth < 2) {

    makeRandIndV2(WCARD_PROB, &a, myArrayL, myArrayC);
    countb = 0;
    countboth = 0;
    for (iterator = auditList; iterator; iterator = iterator->next) {
      myInd = (individual*)iterator->data;
      

      if ( compare_a(a,myInd) && compare_b(a,myInd) ) {
	g_printf("matched both\n");
	g_print("rand  ");
	print_individual(a);
	g_print("audit ");
	print_individual(myInd);
	countboth++;
      } else
	g_print("-");

      if ( compare_b(a,myInd) ) {
	countb++;
	print_individual(myInd);
      }
    }
    g_slice_free1(sizeof(individual), a);
  }


  //  g_printf("Matched this many b in the audit: %d\n:",countb);
  g_print("Got countboth of %d\n", countboth);
  g_print("Got countb of %d\n", countb);
  g_print("length of audit list %d\n", g_slist_length(auditList));



  g_print("\n");





  return 0;

}
