/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "types.h"
#include "print.h"
#include "service_attacks.h"
#include "rand.h"

int main() {
  GSList *training = NULL;
  guint i;

  GRand *myRand;
  individual *theInd;

  // Empty the list
  if (training != NULL)
    {
      g_slist_free(training);
      training = NULL;
    }
  // Initialize the random number generator
  myRand = g_rand_new();

  // individual 1
  for (i=0; i<5;i++) {
    makeRandIndV1(myRand, &theInd);
    training = g_slist_append(training, theInd); 
  }


  //print the list data
  display_list(training);

  //Free the list
  g_slist_free(training);

  return 0;
}
