/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gprintf.h>
#include "types.h"
#include "print.h"
#include "read_bsm.h"
#include "service_attacks.h"

#ifndef SWAP_4
#define SWAP_4(x) ( ((x) << 24) | \
         (((x) << 8) & 0x00ff0000) | \
         (((x) >> 8) & 0x0000ff00) | \
         ((x) >> 24) )
#endif


gboolean compare(int *a, int *b)
{
  gboolean rvalue;
  if (*a == *b)
    rvalue = TRUE;
  else
    rvalue = FALSE;
  return rvalue;
}

void printeach(gpointer a, gpointer b, gpointer userdata) {
 
  g_printf("%s Key is %d count is %d\n",(char *)userdata,*(int *)a, *(int *)b);
}

void printeachchar(gpointer a, gpointer b, gpointer userdata) {
 
  g_printf("%s Key is %u count is %d\n",(char *)userdata, *(guchar *)a, *(guint *)b);
}

int main() {
  GSList *auditData = NULL;
  GHashTable *myHTableL[NUM_HTABLES];
  GHashTable *myHTableC[NUM_HTABLES][SUBH];
  int nRecords = 0;
  int i,j; // loop counters
  int size; // magnitude

  for (i=0; i< NUM_HTABLES;i++) 
    myHTableL[i] = g_hash_table_new_full(g_int_hash,g_int_equal, 
					(GDestroyNotify)destroyL_key,
					(GDestroyNotify)destroyL_value);

  for (i=0; i< NUM_HTABLES;i++) 
    for (j=0; j<SUBH; j++)
      myHTableC[i][j] = g_hash_table_new_full(g_char_hash,g_char_equal, 
					      (GDestroyNotify)destroyC_key,
					      (GDestroyNotify)destroyL_value);
  char *myfile = "./bsm.list";
  //  char *myfile2 = "./bsm2.list";

  //nRecords = load_audit(&auditData, myfile);

  //g_printf("Read %d records\n",nRecords);


  //print the list data
  //display_list(auditData);

  //Free the list
  //g_slist_free(auditData);
  auditData = NULL;

  g_printf("Second set of audit data\n");
  nRecords = load_audit_unique(&auditData, myfile, myHTableL, myHTableC);
  g_printf("Read %d records\n",nRecords);

  display_list(auditData);

  size = g_hash_table_size(myHTableL[G_DEST_PORT]);
  g_printf("Number of unique blah is %d\n",size);

  g_hash_table_foreach(myHTableL[G_DEST_PORT], printeach, "Dest Ports list");
  g_hash_table_foreach(myHTableL[G_SOURCE_PORT], printeach, "Source Ports list");
  g_hash_table_foreach(myHTableC[G_DURATION][3], printeachchar, "Seconds");

  g_hash_table_foreach(myHTableC[G_DURATION][2], printeachchar, "Minutes");
  g_hash_table_foreach(myHTableL[G_ATTACK], printeach, "attack");
  g_hash_table_foreach(myHTableC[G_DEST_IP][2], printeachchar, "Dest IP [2]");
  g_hash_table_foreach(myHTableC[G_DEST_IP][0], printeachchar, "Dest IP [0]");

  return 0;
}
