/* 
 *         GA Net - a genetic algorithm for generating Network Intusion Rules
 *
 *       Copyright (C) 2010 Brian E. Lavender <brian@brie.com> 
 *
 *                     http://www.brie.com/brian/ganet/ 
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <string.h>
#include <glib.h>
#include <glib/gprintf.h>
#include "types.h"
#include "print.h"
#include "read_bsm.h"
#include "service_attacks.h"
#include "randslot.h"

#define WCARD_PROB 0.10

#ifndef SWAP_4
#define SWAP_4(x) ( ((x) << 24) | \
         (((x) << 8) & 0x00ff0000) | \
         (((x) >> 8) & 0x0000ff00) | \
         ((x) >> 24) )
#endif


gboolean compare(int *a, int *b)
{
  gboolean rvalue;
  if (*a == *b)
    rvalue = TRUE;
  else
    rvalue = FALSE;
  return rvalue;
}

void printeach(gpointer a, gpointer b, gpointer userdata) {
 
  g_printf("%s Key is %d count is %d\n",(char *)userdata,*(int *)a, *(int *)b);
}

void printeachchar(gpointer a, gpointer b, gpointer userdata) {
 
  g_printf("%s Key is %u count is %d\n",(char *)userdata, *(guchar *)a, *(guint *)b);
}

int main() {
  GSList *auditList = NULL;

  GArray *myArrayL[NUM_HTABLES];
  GArray *myArrayC[NUM_HTABLES][SUBH];

  
  gint nRecords = 0;
  gint i,j; // loop counters
  int size; // magnitude
  gint neg1 = -1;
  guint mySlot; // random slot number picked
  guint tmpChrome[NUM_GENE]; // tempChrome created
  time_stamp myT; // temporary time stamp data
  IPAddr myIP; // temporary IP address
  individual *a;
  char *myfile = "./bsm.list";
  //char *myfile2 = "./bsm2.list";

  nRecords = build_audit_array(&auditList, myArrayL, myArrayC, myfile);


  display_list(auditList);


  // Check loaded data
  nRecords = myArrayL[G_DEST_PORT]->len;
  g_printf("The size is (including wildcard) %d\n", nRecords );
  for (i = 0; i < nRecords; i++)
    g_print ("slot %d has value of %d\n",
	     i, g_array_index (myArrayL[G_DEST_PORT], guint, i) );

  nRecords = myArrayC[G_SRC_IP][3]->len;
  g_printf("The size is SRC_IP[3] (including wildcard) %d\n", nRecords );
  for (i = 0; i < nRecords; i++)
    g_print ("slot %d has value of %d\n",
	     i, g_array_index (myArrayC[G_SRC_IP][3], guchar, i) );

  nRecords = myArrayC[G_DURATION][3]->len;
  g_printf("The size is G_DURATION[3] (including wildcard) %d\n", nRecords );
  for (i = 0; i < nRecords; i++)
    g_print ("slot %d has value of %d\n",
	     i, g_array_index (myArrayC[G_DURATION][3], guchar, i) );

  // Do a sample pick
  mySlot = randslot(myArrayC[G_DURATION][3]->len, WCARD_PROB);
  g_print ("rand value of %d G_DURATION [3]\n",
	   g_array_index (myArrayC[G_DURATION][3], guchar, mySlot) );

  //  time_stamp myT; // temporary time stamp data
  // IPAddr myIP; // temporary IP address  
  myT.byte[0] = 0xff; // not used, all should be -1

  // Hours, Minutes, Seconds
  for (i=1; i<4; i++) {
    mySlot = randslot(myArrayC[G_DURATION][i]->len, WCARD_PROB);
    myT.byte[i] = g_array_index (myArrayC[G_DURATION][i], guchar, mySlot);
  }
  tmpChrome[G_DURATION] = myT.tot; // duration

  // Service
  mySlot = randslot(myArrayL[G_SERVICE]->len, WCARD_PROB);
  tmpChrome[G_SERVICE] = g_array_index (myArrayL[G_SERVICE], guint, mySlot);

  // Source Port
  mySlot = randslot(myArrayL[G_SOURCE_PORT]->len, WCARD_PROB);
  tmpChrome[G_SOURCE_PORT] = g_array_index (myArrayL[G_SOURCE_PORT], guint, mySlot);

  // Dest Port
  mySlot = randslot(myArrayL[G_DEST_PORT]->len, WCARD_PROB);
  tmpChrome[G_DEST_PORT] = g_array_index (myArrayL[G_DEST_PORT], guint, mySlot);

  // Source IP xxx.xxx.xxx.xxx
  //            0   1   2   3
  for (i=0; i<4; i++) {
    mySlot = randslot(myArrayC[G_SRC_IP][i]->len, WCARD_PROB);
    myIP.octet[i] = g_array_index (myArrayC[G_SRC_IP][i], guchar, mySlot);
  }
  tmpChrome[G_SRC_IP] = myIP.full; // source IP

  // Dest IP xxx.xxx.xxx.xxx
  //          0   1   2   3
  for (i=0; i<4; i++) {
    mySlot = randslot(myArrayC[G_DEST_IP][i]->len, WCARD_PROB);
    myIP.octet[i] = g_array_index (myArrayC[G_DEST_IP][i], guchar, mySlot);
  }
  tmpChrome[G_DEST_IP] = myIP.full; // dest IP

  // Attack. Do not select wildcard, so put its probability at 0.
  mySlot = randslot(myArrayL[G_ATTACK]->len, 0.0 );
  tmpChrome[G_ATTACK] = g_array_index (myArrayL[G_ATTACK], guint, mySlot);

  a = (individual *)g_slice_alloc0(sizeof(individual));

  // Copy the temp chromosome into the individual
  g_memmove(a->chrome, tmpChrome, 4 * NUM_GENE);
  strncpy(a->desc, 
	  "Training Chromosome", 80);

  g_printf("Random individual we just created!\n");

  print_individual(a);

  return 0;

}
