#!/usr/bin/perl

# Configuration Variables
# Change these variables to match your web server's configuration

use File::Find;
use strict;


my $base_dir = "/home/brian/public_html/bbd";




finddepth(\&wanted, $base_dir);


sub wanted { 

  if (/\.html$/) {

    my $file = "$File::Find::name";
    my $old = "$file";
    my $new = "$file.tmp.$$";
    my $bak = "$file.bak";

    open(OLD, "< $old")         or die "can't open $old: $!";
    open(NEW, "> $new")         or die "can't open $new: $!";


    # Correct typos, preserving case
    while (<OLD>) {
      if (/<BODY.*?>/) {
	(print NEW $_)          or die "can't write to $new: $!";
	print NEW '<!-- replace navigable bar begin -->',"\n";
	print NEW '<A HREF="/maps/brian.map">',"\n";
	print NEW '<IMG SRC="/brian/pictures/bar.gif" WIDTH=551 HEIGHT=28 BORDER=0 ISMAP>',"\n";
	print NEW '</A>',"\n";
	print NEW '<!-- replace navigable bar end -->',"\n";
      } else {
	(print NEW $_)          or die "can't write to $new: $!";
      }
    }

    close(OLD)                  or die "can't close $old: $!";
    close(NEW)                  or die "can't close $new: $!";

    rename($old, $bak)          or die "can't rename $old to $bak: $!";
    rename($new, $old)          or die "can't rename $new to $old: $!";

  }

}


